<?php

namespace App\Providers;

use Illuminate\Support\ServiceProvider;
use Illuminate\Support\Facades\DB;
use Illuminate\Support\Facades\Config;

class PaystackConfigServiceProvider extends ServiceProvider
{
    public function register()
    {
        //
    }

    public function boot()
    {
        try {
            if (DB::connection()->getSchemaBuilder()->hasTable('payment_settings')) {
                $paystack = DB::table('payment_settings')->where('unique_keyword', 'paystack')->first();
                if ($paystack && $paystack->information) {
                    $info = json_decode($paystack->information);
                    if (isset($info->key)) {
                        Config::set('settings.paystack_public_key', $info->key);
                    }
                }
            }
        } catch (\Throwable $e) {
            // Optional: log error or silently fail
        }
    }
}
