<?php

namespace App\Providers;

use Illuminate\{
    Support\ServiceProvider,
    Support\Facades\DB
};
use Illuminate\Pagination\Paginator;
use Illuminate\Support\Facades\URL;
use Illuminate\Support\Facades\Config;

class AppServiceProvider extends ServiceProvider
{
    public function boot()
{
    if (env('APP_ENV') === 'production') {
        URL::forceScheme('https');
    }

    Paginator::useBootstrap();

    // Set Paystack public key from JSON config in DB
    try {
        if (DB::connection()->getSchemaBuilder()->hasTable('payment_settings')) {
            $paystack = DB::table('payment_settings')->where('unique_keyword', 'paystack')->first();

            if ($paystack && $paystack->information) {
                $info = json_decode($paystack->information);
                if (isset($info->key)) {
                    Config::set('settings.paystack_public_key', $info->key);
                }
            }
        }
    } catch (\Throwable $e) {
        // Prevent crash on database errors
    }

    // Safely bind settings to all views
    try {
        view()->composer('*', function ($settings) {
            $settings->with('setting', DB::table('settings')->find(1));
            $settings->with('extra_settings', DB::table('extra_settings')->find(1));
            $settings->with('menus', DB::table('menus')->find(1));

            if (!session()->has('popup')) {
                view()->share('visit', 1);
            }
            session()->put('popup', 1);
        });
    } catch (\Throwable $e) {
        // Avoid failure during boot
    }
}


    public function register()
    {
    }
}